# -*- coding: utf-8 -*-
import logging

from passport.backend.logbroker_client.core.events.filters import BasicFilter
from passport.backend.logbroker_client.core.handlers.base import BaseHandler
from passport.backend.logbroker_client.core.handlers.utils import MessageChunk
from passport.backend.logbroker_client.{{cookiecutter.project_slug_snake}}.events import (
    {{cookiecutter.project_slug_upper_camel}}Event,
)


log = logging.getLogger(__name__)


class {{cookiecutter.project_slug_upper_camel}}Handler(BaseHandler):
    handler_name = '{{cookiecutter.project_slug_snake}}'

    def __init__(self, config, **kwargs):
        super({{cookiecutter.project_slug_upper_camel}}Handler, self).__init__(config=config, **kwargs)
        events_classes = [
            {{cookiecutter.project_slug_upper_camel}}Event,
        ]
        self.filter = BasicFilter(events_classes)

    def parse_message(self, message):
        return self.filter.filter(message)

    def process(self, header, data):
        message = MessageChunk(header, data)
        events = self.get_message_entries(message)
        for event in events:
            self.process_event(event)
        return True

    def process_event(self, event):
        # TODO: event processing
        pass
